#include "Servo.h"

Servo servo;  // création de l'objet "servo"

int sensorPinEntree = 8;  // ENTREE broche sur laquelle le capteur est connecté
int sensorPinSortie = 9;  // SORTIE broche sur laquelle le capteur est connecté

int sensorValueEntree = 1;  // variable pour stocker la valeur de sortie du capteur
int sensorValueSortie = 0;  // variable pour stocker la valeur de sortie du capteur

int LED_IN = 16;   // ROUGE - la broche ou est branche notre led
int LED_OUT = 14;  // VERTE - la broche ou est branche notre led

void setup() {

     servo.attach(10);  // attache le servo au pin spécifié
     servo.write(95);    // Barrière en position ouverte

     pinMode(sensorPinEntree, INPUT);  // Configurer la broche du capteur en entrée
     pinMode(sensorPinSortie, INPUT);

     pinMode(LED_IN, OUTPUT);   // On declare la led en sortie
     pinMode(LED_OUT, OUTPUT);  // On declare la led en sortie

     // Configurer la communication série pour afficher les informations sur l'ordinateur
     Serial.begin(9600);
}

void loop() {


     sensorValueEntree = digitalRead(sensorPinEntree);
     sensorValueSortie = digitalRead(sensorPinSortie);

     digitalWrite(LED_OUT, HIGH);
     digitalWrite(LED_IN, LOW);

     Serial.print("ATTENTE : ");
     Serial.print("OUT - Entrée : ");
     Serial.print(sensorValueEntree);
     Serial.print(" ~ Sortie  : ");
     Serial.println(sensorValueSortie);

     while (sensorValueEntree == 0 and sensorValueSortie == 1) {

          servo.write(7);
          Serial.print("BOUCLE : ");
          Serial.print("IN - Entrée : ");
          Serial.print(sensorValueEntree);
          Serial.print(" ~ Sortie  : ");
          Serial.println(sensorValueSortie);
          sensorValueSortie = digitalRead(sensorPinSortie);

          digitalWrite(LED_OUT, LOW);
          digitalWrite(LED_IN, HIGH);
     }

     servo.write(95);
}